<?
// maillist.php
// Chapter 7 - Foundation PHP for Flash

    if (!isset($email) || !isset($name) || empty($email) || empty($name)) {
        fail("Both a name and an email address are required");
    }
    
    $email = strtolower($email);
    
    switch($action) {
        case "subscribe":
            subscribe($name, $email);
            break;
        
        case "unsubscribe":
            unsubscribe($email);
            break;
    
        default:
            fail("Unknown action: $action");
    }
    
    
function subscribe($name, $email) {

    if (isSubscribed($email)) {
        fail("$email already subscribed to mailing list");
    }

    $joinDate = time();
    
    $file = fopen('subscriber.dat', 'a+');
    
    if (!$file) {
        fail("Error: Couldn't open subscriber file");
    }
    
    fputs($file, "$name|$email|$joinDate\n");
    fclose($file);
    
    success();
}

       
function unsubscribe($email) {
    if (!isSubscribed($email)) {
        fail("$email not subscribed to mailing list");
    }

    $subscribers = file('subscriber.dat');
    
    if (!$subscribers) {
        fail("Error: Couldn't open subscriber file");
    }
    
    foreach($subscribers as $count => $subscriber) {
        $info = explode('|', $subscriber);
        
        if($info[1] == $email) {
            unset($subscribers[$count]);
        }
    }
    
    $file = fopen('subscriber.dat', 'w');
    
    if (!$file) {
        fail("Couldn't remove subscriber from file");
    }
    
    foreach($subscribers as $subscriber) {
        fwrite($file, $subscriber);
    }        

    fclose($file);
        
    success();
}


function sendEmail($Email, $Name) {
    $mailTo = "$Name <$Email>";
    $mailFrom = "From: Foundation PHP for Flash Mailing List <maillist@phpforflash.com>";
    $mailSubject = "Your registration confirmation...";
    $mailBody = "Dear $Name,\n\nYour details have been added to the Foundation PHP for Flash mailing list. Details of the latest developments for this book will be mailed to you at $Email. You can also check out the latest developments at http://www.phpforflash.com and http://www.friendsofed.com\n\nIf you wish to remove yourself from this mailing list at any time use the following link:\nhttp://www.phpforflash.com/maillist.php?Action=unsubscribe&Email=$Email\n\nThank you!\n\nFoundation PHP for Flash Team";
    mail($mailTo, $mailSubject, $mailBody, $mailFrom);
}

function mailAdmin($Email, $Name) {
    $mailTo = "Steve Webster <steve@codejunkie.co.uk>";
    $mailFrom = "From: Foundation PHP for Flash Mailing List <fphpff@codejunkie.co.uk>";
    $mailSubject = "New Subscriber Alert...";
    $mailBody = "$Name ($Email) has just signed up";
    mail($mailTo, $mailSubject, $mailBody, $mailFrom);
}


function isSubscribed($email) {
    $matchFound = false;
    $subscribers = file('subscriber.dat');
    
    if ($subscribers) {
        foreach($subscribers as $count => $subscriber) {
            $info = explode('|', $subscriber);
        
            if($info[1] == $email) {
                $matchFound = true;
            }
        }
    }
    
    return $matchFound;
}

function isBanned($email) {
    return false;
}

function fail($errorMsg) {
    $errorMsg = urlencode($errorMsg);
    print "&result=Fail&errorMsg=$errorMsg";
    exit;
}

function success() {
    print "&result=Okay";
    exit;
}

?>
